// bergmark - November 1998 - jtapi exercises
// Used for Spring 1999 Telephony project

/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.gtwy.pbx;

// MyCallObserver is used by the Dialer class to look at calls

import javax.telephony.*;
import javax.telephony.events.*;

/**
 * Class that observes a Call.  If a call observer is attached to
 * a call, and if logging is turned on, then status messages will be
 * printed to the terminal indicating progress of the call.
 */
public class MyCallObserver implements CallObserver {

   private static final String ME = "MyCallObserver: ";
   private boolean LOG = false;

   /**
    * Constructor that specifies setting for logging.
    */
   public MyCallObserver ( boolean logging ) 
      {
       LOG = logging;
       if (LOG) System.out.println(ME + "Creating a call observer");
      }

   /**
    * Default constructor
    */
   public MyCallObserver ( ) {}

   /**
    * Alerts observer that state of telephone call has changed.
    * Extensive information about terminal and address is printed,
    * along with description of the new state.
    */
   public void callChangedEvent(javax.telephony.events.CallEv[] e ) {
      if (LOG) {
         System.out.print ("The call observer got " + e.length + " event");
         if ( e.length > 1) System.out.print ( "s" );
         System.out.println ( e.length > 0 ? ":" : "s:" );
         for (int i = 0; i < e.length; i++ ) {

         // Try to find a descriptive terminal name for this event
         String name = null;
         if (e[i] instanceof ConnEv) {
            try { Connection con = ((ConnEv)e[i]).getConnection();
               Address a = con.getAddress();
               name = a.getName();
               System.out.print  ("On address " + name + ": ");
            } catch (Exception ex) { System.out.println (ex); }
         }
         else if (e[i] instanceof TermConnEv) {
	    TerminalConnection termconn = null;
            try { TermConnEv tcev = (TermConnEv) e[i];
	       termconn = tcev.getTerminalConnection();
	       Terminal t = termconn.getTerminal();
               name = t.getName();
               System.out.print  ("On terminal " + name + ": ");
            } catch (Exception ex) { System.out.println (ex); }
         }

         switch ( e[i].getID() ) {
            case CallActiveEv.ID:
               System.out.println ("Call Active event.");
               break;
            case CallInvalidEv.ID:
               System.out.println ("Call Invalid event.");
               break;
            case CallObservationEndedEv.ID:
               System.out.println ("Call Observation Ended event.");
               break;
	    case ConnAlertingEv.ID:
	       System.out.println ( "Connection Alerting Event");
	       break;
	    case ConnConnectedEv.ID:
	       System.out.println( "Connection Connected Event");
	       break;
	    case ConnCreatedEv.ID:
	       System.out.println("Connection Created Event");
               break;
	    case ConnDisconnectedEv.ID:
	       System.out.println("Connection Disconnected Event");
               break;
	    case ConnFailedEv.ID:
	       System.out.println("Connection Failed Event");
               break;
	    case ConnInProgressEv.ID:
	       System.out.println("Connection In Progress Event");
               break;
	    case ConnUnknownEv.ID:
	       System.out.println("Connection Unknown Event");
               break;
	    case TermConnActiveEv.ID:
	       System.out.println("Terminal Connection Active Event");
               break;
	    case TermConnCreatedEv.ID:
	       System.out.println("Terminal Connection Created Event");
               break;
	    case TermConnDroppedEv.ID:
	       System.out.println("Terminal Connection Dropped Event");
               break;
	    case TermConnPassiveEv.ID:
	       System.out.println("Terminal Connection Passive Event");
               break;
	    case TermConnRingingEv.ID:
	       System.out.println("Terminal Connection Ringing Event");
               break;
	    case TermConnUnknownEv.ID:
	       System.out.println("Terminal Connection Unknown Event");
               break;
            default:
               System.out.println ("unknown call event " + e[i].getID() );
         }
      }
      System.out.println ("\n");
      }
   }

} // MyCallObserver

